/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.NativeBridge;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

class Signature {
    NativeBridge bridge;
    Class[] parms;

    public Signature(String signature, NativeBridge bridge) throws IOException {
        this.bridge = bridge;
        this.parseSignature(signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] readArguments(DataInputStream in) throws IOException {
        Object[] args = new Object[this.parms.length];
        int i = 0;
        while (i < args.length) {
            Class parm = this.parms[i];
            if (parm.isPrimitive()) {
                if (parm == Boolean.TYPE) {
                    args[i] = new Boolean(in.readBoolean());
                } else if (parm == Byte.TYPE) {
                    args[i] = new Byte(in.readByte());
                } else if (parm == Character.TYPE) {
                    args[i] = new Character(in.readChar());
                } else if (parm == Short.TYPE) {
                    args[i] = new Short(in.readShort());
                } else if (parm == Integer.TYPE) {
                    args[i] = new Integer(in.readInt());
                } else if (parm == Long.TYPE) {
                    args[i] = new Long(in.readLong());
                } else if (parm == Float.TYPE) {
                    args[i] = new Float(in.readFloat());
                } else {
                    if (parm != Double.TYPE) throw new IOException("Unknown primitive type");
                    args[i] = new Double(in.readDouble());
                }
            } else {
                String name = in.readUTF();
                args[i] = this.bridge.lookupRegisteredObject(name);
                if (args[i] == null && !name.equals("null")) {
                    throw new IOException("Unknown object name \"" + name + "\" passed as argument " + i);
                }
            }
            ++i;
        }
        return args;
    }

    public Class[] getParameterClasses() {
        return this.parms;
    }

    void parseSignature(String signature) throws IOException {
        ArrayList parms = new ArrayList();
        int len = signature.length();
        StringBuffer parmClassName = new StringBuffer();
        int index = 0;
        while (index < len) {
            block18: {
                block20: {
                    block19: {
                        char c = signature.charAt(index);
                        switch (c) {
                            case '[': {
                                parmClassName.append(c);
                                break block18;
                            }
                            case 'L': {
                                int end = signature.indexOf(59, index + 1);
                                if (end == -1) {
                                    throw new IOException("Illegal signature string \"" + signature + "\", starting at index " + index);
                                }
                                parmClassName.append(signature.substring(index, end + 1));
                                index = end;
                                break;
                            }
                            default: {
                                parmClassName.append(c);
                            }
                        }
                        if (parmClassName.length() != 1) break block19;
                        switch (parmClassName.charAt(0)) {
                            case 'Z': {
                                parms.add(Boolean.TYPE);
                                break block20;
                            }
                            case 'B': {
                                parms.add(Byte.TYPE);
                                break block20;
                            }
                            case 'C': {
                                parms.add(Character.TYPE);
                                break block20;
                            }
                            case 'S': {
                                parms.add(Short.TYPE);
                                break block20;
                            }
                            case 'I': {
                                parms.add(Integer.TYPE);
                                break block20;
                            }
                            case 'J': {
                                parms.add(Long.TYPE);
                                break block20;
                            }
                            case 'F': {
                                parms.add(Float.TYPE);
                                break block20;
                            }
                            case 'D': {
                                parms.add(Double.TYPE);
                                break block20;
                            }
                            default: {
                                throw new IOException("Illegal type char \"" + parmClassName.charAt(0) + "\" in signature string \"" + signature + "\", at index " + index);
                            }
                        }
                    }
                    String className = parmClassName.charAt(0) == '[' ? parmClassName.toString() : parmClassName.substring(1, parmClassName.length() - 1);
                    className = className.replace('/', '.');
                    try {
                        this.getClass();
                        parms.add(Class.forName(className));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Class name not found: \"" + className + "\"");
                    }
                }
                parmClassName.setLength(0);
            }
            ++index;
        }
        this.parms = new Class[parms.size()];
        parms.toArray(this.parms);
    }
}

